function [ S1,S2,err1,err2 ] = Assembly( delta )
%Assemble stiffness matrices in S^0_2(delta) for diffusion problem.
%   The diffusion problem in weak formulation is for all basis N_{j}
%   0 = \int_{\Omega} N_{j}\left\{u_{t}-ku_{zz}\right\} 
%     = \sum_{i}{ \int_{\Omega}N_{j}N_{i} }c'_{i} + \sum_{i}{ k\int_{\Omega}N'_{j}N'_{i} }c_{i}
%delta is the original knot sequence, not yet extended. For this example k
%= .75 and \Omega = [0,6]. S_{1} is the matrix coefficient on c' and S_{2}
%is the analogous on c. MAKE SURE delta is a partition of [0,6]

%Build extended knot sequence.
[extdelta,n] = extpar(delta,0,2);

%Assemble S1
S1 = zeros(n,n);
In = eye(n); %For easily extracting the basis coefficient vectors.
Max_RMS1 = zeros(n,n); %For watching product spline error
for i=1:n %columns
    for j=1:n %rows
        Nj = In(j,:);
        Ni = In(i,:);
        [extdeltap,Np,np,rms] = prdspl(delta,0,2,2,Nj,Ni);
        S1(j,i) = intspl(4,extdeltap,Np,0,6);
        Max_RMS1(j,i) = rms;
    end
end


%Assemble S2
S2 = zeros(n,n);
Max_RMS2 = zeros(n,n);
for i=1:n
    for j=1:n
        Nj = In(j,:);
        Ni = In(i,:);
        [deltad,Njd,nd] = derspl(2,extdelta,Nj); %Compute derivatives
        [deltad,Nid,nd] = derspl(2,extdelta,Ni);
        
        [extdeltap,Np,np,rms] = prdspl(delta,-1,1,1,Njd,Nid); %The derivative continuity is not C0 bc parent was C0.
        S2(j,i) = intspl(2,extdeltap,Np,0,6);                 %It's actually discontinuous. -1 is formal, not clear if
        Max_RMS2(j,i) = rms;                                  %this actually correct.
    end
end

S2 = .75*S2; %Incorporate the diffusion coefficient.
err1 = max(max( Max_RMS1 ));
err2 = max(max( Max_RMS2 ));



end

